from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick the dice from the floor (approach along z-axis)
        dice_pose_key = "dice1"
        if dice_pose_key not in Object:
            raise KeyError(f"Object list does not contain {dice_pose_key}")
        robot.execute_movement(Object[dice_pose_key], mode=1, axis=2)

        # Step 2: Pick the drawer handle (approach along x-axis)
        handle_pose_key = "drawer_top_handle"
        if handle_pose_key not in Object:
            raise KeyError(f"Object list does not contain {handle_pose_key}")
        robot.execute_movement(Object[handle_pose_key], mode=1, axis=0)

        # Step 3: Pull the drawer open using the handle (approach along x-axis)
        robot.execute_movement(Object[handle_pose_key], mode=4, axis=0, distance=0.1)

        # Step 4: Place the dice into the drawer (at left placement pos, approach along z-axis)
        drawer_place_key = "drawer_top_place_left"
        if drawer_place_key not in Object:
            raise KeyError(f"Object list does not contain {drawer_place_key}")
        robot.execute_movement(Object[drawer_place_key], mode=2, axis=2)
        
        # Step 5: Push the drawer closed (from handle pos, approach along x-axis)
        robot.execute_movement(Object[handle_pose_key], mode=3, axis=0, distance=0.1)

        # Finally, return to ready-pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"[ERROR][Task Execution] {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()