from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 from floor (z-axis/top-down approach, execute_pick)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Pick up bottom drawer handle (x-axis approach, execute_pick)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 3: Pull open bottom drawer using handle (x-axis, execute_pull, distance=0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
        # Step 4: Place dice1 into bottom drawer (z-axis/top-down at drawer left place, execute_place)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"[ERROR] Exception during oracle sequence: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()