from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick dice1 from floor (axis=2: z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print("Step 1 (pick dice1) failed:", e)

    try:
        # Step 2: execute_pick handle_top from floor (axis=0: x-axis for handle)
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
    except Exception as e:
        print("Step 2 (pick handle_top) failed:", e)
    
    try:
        # Step 3: execute_pull drawer_top with handle_top at drawer-area (mode=4, axis=0)
        # Assuming we don't have a specific drawer_area handle pose, reuse handle_top pose.
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print("Step 3 (pull drawer_top) failed:", e)

    try:
        # Step 4: execute_go from drawer-area to floor (mode=7)
        robot.execute_movement(mode=7)
    except Exception as e:
        print("Step 4 (go drawer-area to floor) failed:", e)

    try:
        # Step 5: execute_pick dice1 from floor (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print("Step 5 (pick dice1 again) failed:", e)

    try:
        # Step 6: execute_go from floor to drawer-area (mode=7)
        robot.execute_movement(mode=7)
    except Exception as e:
        print("Step 6 (go floor to drawer-area) failed:", e)

    try:
        # Step 7: execute_place dice1 into drawer_top at drawer-area (mode=2, axis=2)
        # Place expects dice1 pose; use the pose for dice1 as a position above the open drawer, axis=2 (z)
        robot.execute_movement(Object["dice1"], mode=2, axis=2)
    except Exception as e:
        print("Step 7 (place dice1 in drawer) failed:", e)

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
