from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # Step 1: Move from ready-pose to handle_top_location
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
        
        # Step 2: Pick handle_top at handle_top_location (axis=0, x-axis approaching handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        
        # Step 3: Pull drawer_top using handle_top at handle_top_location (axis=0, x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)
        
        # Step 4: Move from handle_top_location to dice1_location
        robot.execute_movement(Object["yellow_dice"], mode=7)
        
        # Step 5: Pick dice1 at dice1_location (axis=2, z-axis for normal objects)
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)
        
        # Step 6: Move from dice1_location to drawer_top_place_location
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        
        # Step 7: Place dice1 into drawer at drawer_top_place_location (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        
        # Step 8: Push drawer_top closed at drawer_top_place_location (axis=0, push along x-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=3, axis=0, distance=0.10)
        
        # Step 9: Return from drawer_top_place_location to ready-pose
        robot.execute_movement(mode=8)
        
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()