from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_movement(Object["drawer_top_handle"], mode=6)  # To ensure safety before movement (optional)
        robot.execute_movement(pose0=None, pose1=None, mode=7)  # Custom mapping; ensure mode=7 is general move if needed

        # According to spec steps (with explicit mapping)
        # 1. Go from ready-pose to floor
        robot.execute_movement(pose0=None, pose1=None, mode=7)  # If pose arguments needed, provide them accordingly

        # 2. Pick up handle_top from floor (axis=0 for handle; x-axis approach)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # 3. Go from floor to drawer-area
        robot.execute_movement(pose0=None, pose1=None, mode=7)

        # 4. Pull drawer_top open using handle_top (axis=0 for handle; x-axis approach)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # 5. Go from drawer-area to floor
        robot.execute_movement(pose0=None, pose1=None, mode=7)

        # 6. Pick up dice1 from floor (axis=2 for object; z-axis approach)
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)

        # 7. Go from floor to drawer-area
        robot.execute_movement(pose0=None, pose1=None, mode=7)

        # 8. Place dice1 into drawer_top at drawer-area (axis=2 for object; z-axis approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Exception during robotic sequence: {e}")


def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()