from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle_top (drawer_top_handle) from floor
        # Approach handle along x-axis (axis=0). 
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: Pull open drawer_top using the handle
        # The handle is still at the same pose. A longer pull, so distance=0.1
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 3: Pick the dice (pick dice1 from floor)
        # Approach dice along z-axis (axis=2).
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)
        # Optionally go to ready pose after pick for stability
        robot.execute_movement(mode=8)

        # Step 4: Place dice into the open drawer
        # The pose can be drawer_top_place_left or drawer_top_place_right.
        # We'll use the left placement pose for "put a single dice into the drawer".
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Optionally go to ready pose after place
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()