from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_movement(Object["drawer_top_handle"], Object["drawer_top_handle"], mode=6)  # dummy rotate to ensure correct orientation, can be omitted if not required
        robot.execute_movement(mode=7)
        
        # Step 1: Move from ready-pose to floor (execute_go)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # fallback go
        # [Spec: execute_go "ready-pose" -> "floor"]
        # Since we don't have explicit poses for "ready-pose" and "floor" in Object, just use mode=7 for go

        # Step 2: Pick up the handle from the floor (execute_pick)
        # Approach handle_top along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 3: Move from floor to drawer-area (execute_go)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # again: mode=7 = execute_go

        # Step 4: Pull to open the drawer (execute_pull)
        # Pull drawer_top using handle_top at drawer-area, along x axis
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 5: Move from drawer-area to floor (execute_go)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
        
        # Step 6: Pick up the dice from the floor (execute_pick)
        # Approach dice1 along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=1, axis=2)

        # Step 7: Move from floor to drawer-area (execute_go)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # Step 8: Place dice1 into drawer_top at drawer-area (execute_place) along z-axis
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 9: Push to close the drawer (execute_push)
        # Push drawer_top at drawer-area along x axis
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during execution: {e}")


def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
