from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from the floor (axis=2 for objects)
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)

        # Step 2: Pick up handle_top from the floor (axis=0 for handles)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 3: Pull open the top drawer using handle (axis=0 for pulling drawer handles)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: Place dice into the opened top drawer (axis=2 for objects)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Optionally, return to ready pose at the end
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()