from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Mapping named locations to actual object/pose keys in Object list
    # We interpret the "location" parameters in the plan as:
    #   - handle_top_location: Object["drawer_top_handle"]
    #   - drawer_top_area: Object["drawer_top_handle"] (used for handle/drawer area)
    #   - dice1_location: Object["dice1"]
    #   - drawer_top_place_area: choose Object["drawer_top_place_left"] for placing dice1

    # Step 1: Move from ready-pose to handle_top_location
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
    except Exception as e:
        print("Error in step 1 - execute_go to handle_top_location:", e)

    # Step 2: Pick handle_top at handle_top_location (axis=0 since it's a handle)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error in step 2 - execute_pick handle_top:", e)

    # Step 3: Move from handle_top_location to drawer_top_area
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
    except Exception as e:
        print("Error in step 3 - execute_go to drawer_top_area:", e)

    # Step 4: Pull to open the drawer using handle_top at drawer_top_area
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)
    except Exception as e:
        print("Error in step 4 - execute_pull drawer_top:", e)

    # Step 5: Move from drawer_top_area to dice1_location
    try:
        robot.execute_movement(Object["dice1"], mode=7)
    except Exception as e:
        print("Error in step 5 - execute_go to dice1_location:", e)

    # Step 6: Pick dice1 from dice1_location (axis=2 for objects)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print("Error in step 6 - execute_pick dice1:", e)

    # Step 7: Move from dice1_location to drawer_top_place_area
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
    except Exception as e:
        print("Error in step 7 - execute_go to drawer_top_place_area:", e)

    # Step 8: Place dice1 into drawer at drawer_top_place_area (axis=2 for top-down place)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print("Error in step 8 - execute_place dice1 in drawer:", e)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
