from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to handle_top location (assume 'drawer_top_handle' is at 'handle_top_location')
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

        # Step 2: Pick handle_top (drawer handle), approach axis=0 (x-axis, as per spec)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull to open the drawer (need handle in hand, approach at drawer), axis=0 (x)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 4: Move from handle_top_location to dice1_location (assume dice1 pose)
        robot.execute_movement(Object["dice1"], mode=7)  # execute_go

        # Step 5: Pick dice1 from floor, approach axis=2 (z-axis, general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 6: Move from dice1_location to drawer_top_location (assume 'drawer_top_handle' pose is at drawer front)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

        # Step 7: Place dice1 in the drawer, approach axis=2 (z-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=2, axis=2)  # execute_place

        # Step 8: Move back to ready-pose
        robot.execute_movement(mode=8)  # go_to_ready_pose

        # Step 9: Final gripper action (open/close)
        robot.execute_movement(mode=9)  # execute_gripper(open)

    except Exception as e:
        print(f"[ERROR] Task aborted due to exception: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
