from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Move to handle_top location ===
    # Move from ready-pose to floor, where handle_top is on floor.
    # Our mapping: handle_top is on the floor, so we use Object["drawer_top_handle"] for pose.
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 1 (go to handle_top): {e}")

    # === Step 2: Pick up the handle ===
    # Use axis=0 for handle (x-axis approach)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Step 2 (pick handle_top): {e}")

    # === Step 3: Pull the drawer open ===
    # Execute pull on drawer at same location as handle.
    # Use axis=0 (handle/drawer is pulled along x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.12)
    except Exception as e:
        print(f"[ERROR] Step 3 (pull drawer_top): {e}")

    # === Step 4: Move to dice1 location ===
    # dice1 is on floor; move from handle_top_location to dice1_location (we use pose of dice1)
    try:
        robot.execute_movement(Object["dice1"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 4 (go to dice1): {e}")

    # === Step 5: Pick up dice1 ===
    # For general object, axis=2 (z-axis approach)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"[ERROR] Step 5 (pick dice1): {e}")

    # === Step 6: Move to drawer placing location ===
    # Target is left place in drawer_top (Object["drawer_top_place_left"])
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 6 (go to drawer place): {e}")

    # === Step 7: Place dice into the drawer ===
    # axis=2 (z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"[ERROR] Step 7 (place dice1 in drawer): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
