from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go; interface: mode=7 triggers move

        # Step 2: Pick handle_top (drawer handle) at drawer-area, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull to open drawer (drawer_top) using handle_top at drawer-area, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 4: Pick dice1 at drawer-area, approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 5: Place dice1 in drawer_top at drawer-area, approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

        # Step 6: Return to ready-pose
        robot.execute_movement(Object["drawer_top_handle"], mode=8)  # go_to_ready_pose (mode=8)

    except Exception as e:
        print("Error during task execution:", e)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
