from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    # Step 1: Move from ready-pose to floor
    try:
        robot.execute_movement(Object["dice1"], mode=7, pose0=Object["ready-pose"], pose1=Object["floor"])
    except Exception as e:
        print(f"Error in Step 1 (go to floor): {e}")

    # Step 2: Pick dice1 (on floor), axis=2 (z axis for general object)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 2 (pick dice1): {e}")

    # Step 3: Pick handle_top (on floor), axis=0 (x axis for handle)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 3 (pick handle_top): {e}")

    # Step 4: Move from floor to drawer-area
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7, pose0=Object["floor"], pose1=Object["drawer-area"])
    except Exception as e:
        print(f"Error in Step 4 (go to drawer-area): {e}")

    # Step 5: Pull drawer using handle, axis=0 (x axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 5 (pull drawer): {e}")

    # Step 6: Place dice1 in drawer_top, axis=2 (z axis for general object)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 6 (place dice1 in drawer): {e}")

    # Step 7: Push drawer closed, axis=0 (x axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 7 (push drawer): {e}")

    # Step 8: Return to ready-pose from drawer-area
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7, pose0=Object["drawer-area"], pose1=Object["ready-pose"])
    except Exception as e:
        print(f"Error in Step 8 (return to ready-pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()