from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: Move to handle_top location
        # handle_top is on the floor: choose its pose
        handle_top_location = Object.get("drawer_top_handle", None)
        if handle_top_location is None:
            handle_top_location = Object.get("handle_top", None)
        if handle_top_location is None:
            raise ValueError("handle_top location missing in Object list.")

        # Step 1: execute_go from ready-pose to handle_top_location
        # move: mode=7 is execute_go, but skeleton uses mode=7 for generic go, we use execute_movement with pose for target
        robot.execute_movement(handle_top_location, mode=7)
        
        # Step 2: Pick up handle_top (drawer_top_handle), approach axis 0
        robot.execute_movement(handle_top_location, mode=1, axis=0)
        
        # Step 3: Pull open drawer_top using handle_top, axis 0 (pull x)
        # (Assume pulling from handle_top_location)
        robot.execute_movement(handle_top_location, mode=4, axis=0, distance=0.1)

        # Step 4: Move to dice1 location from handle_top_location
        dice1_location = Object.get("dice1", None)
        if dice1_location is None:
            raise ValueError("dice1 location missing in Object list.")
        robot.execute_movement(dice1_location, mode=7)

        # Step 5: Pick up dice1 (approach along z axis)
        robot.execute_movement(dice1_location, mode=1, axis=2)

        # Step 6: Move to drawer_area (where the drawer_top is), from dice1_location
        drawer_area = Object.get("drawer_top_place_left", None)
        if drawer_area is None:
            drawer_area = Object.get("drawer_top_place_right", None)
        if drawer_area is None:
            drawer_area = Object.get("drawer_area", None)
        if drawer_area is None:
            raise ValueError("drawer_area location missing in Object list.")
        robot.execute_movement(drawer_area, mode=7)

        # Step 7: Place dice1 in drawer_top, approach along z axis (axis=2)
        robot.execute_movement(drawer_area, mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()