from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from 'ready-pose' to 'floor'
        # This can be a no-op if localization is not strictly mapped, but provided for flow.
        robot.execute_movement(Object.get("floor", None), mode=7)

        # Step 2: Pick handle_top from floor (for drawer_top)
        # Object key: "drawer_top_handle" → corresponds to handle_top on the floor
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick, axis=0 for handle

        # Step 3: Move to 'drawer-area'
        robot.execute_movement(Object.get("drawer-area", None), mode=7)

        # Step 4: Pull open drawer_top using handle_top at drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 5: Move back to 'floor'
        robot.execute_movement(Object.get("floor", None), mode=7)

        # Step 6: Pick dice1 from floor
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick, axis=2 for non-handle

        # Step 7: Move to 'drawer-area'
        robot.execute_movement(Object.get("drawer-area", None), mode=7)

        # Step 8: Place dice1 into drawer_top at drawer-area
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

    except Exception as e:
        print(f"[Error] Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()