from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up the handle from the floor (handle_top at ready-pose, approach axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Pull the drawer open using the handle (drawer_top, handle_top, at ready-pose)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick up the trash from inside the drawer (trash1 in drawer_top at ready-pose, approach axis=2 for object)
        robot.execute_movement(Object["trash"], mode=1, axis=2)
        # Step 4: Go to ready pose (simulate go_ready)
        robot.execute_movement(mode=8)
        # Step 5: Place the trash into the bin (trash1 into trash_bin at ready-pose, approach axis=2)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)
        # Step 6: Go to ready pose
        robot.execute_movement(mode=8)
        # Step 7: Pick up the dice from the floor (dice1 at ready-pose, approach axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 8: Go to ready pose
        robot.execute_movement(mode=8)
        # Step 9: Place the dice into the drawer (dice1 into drawer_top at ready-pose, approach axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 10: Go to ready pose
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()