from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Move from ready-pose to floor (simulate as move)
        robot.execute_movement(pose0=Object["ready-pose"], pose1=Object["floor"], mode=7)
        # Pick handle_top from floor at floor (execute_pick, approach along x-axis)
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        # Pull drawer open using handle_top at floor (execute_pull, approach along x-axis, distance=0.1)
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)
        # Pick trash1 from inside drawer_top at floor (simulate as pick, approach along z-axis)
        robot.execute_movement(Object["trash"], mode=1, axis=2)
        # Return to ready-pose (simulate as go to ready pose)
        robot.execute_movement(mode=8)
        # Place trash1 into bin at ready-pose (execute_place, approach along z-axis)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)
        # Return to ready-pose (simulate as go to ready pose)
        robot.execute_movement(mode=8)
        # Pick dice1 from floor at ready-pose (execute_pick, approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Return to ready-pose (simulate as go to ready pose)
        robot.execute_movement(mode=8)
        # Place dice1 into drawer_top at ready-pose (execute_place, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Return to ready-pose (simulate as go to ready pose)
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()