from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to drawer-area
        # execute_go: mode=7, requires both source and destination poses
        # We'll use Object["ready_pose"] and Object["drawer_area"] if available, else fallback to None
        # Since Object_list may not have "ready_pose" and "drawer_area", pass None to use default movement
        robot.execute_movement(pose0=Object.get("ready_pose", None), pose1=Object.get("drawer_area", None), mode=7)

        # Step 2: Pick the handle (handle_top) at drawer-area
        # execute_pick: mode=1, axis=0 (handle: approach along x-axis)
        robot.execute_movement(pose0=Object.get("handle_top", None), mode=1, axis=0)

        # Step 3: Pull the drawer open using the handle
        # execute_pull: mode=4, axis=0 (handle: approach along x-axis), distance=0.1
        # For pulling, we need to be at the handle's pose
        robot.execute_movement(pose0=Object.get("handle_top", None), mode=4, axis=0, distance=0.1)

        # Step 4: Pick the dice (dice1) at drawer-area
        # execute_pick: mode=1, axis=2 (object: approach along z-axis)
        robot.execute_movement(pose0=Object.get("dice1", None), mode=1, axis=2)

        # Step 5: Place the dice into the drawer (drawer_top) at drawer-area
        # execute_place: mode=2, axis=2 (object: approach along z-axis)
        # For placing, use the drawer's pose if available
        robot.execute_movement(pose0=Object.get("drawer_top", None), mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()