from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Pick up the die (dice1) from the floor ===
    try:
        # Approach along z-axis (axis=2) for picking up dice1
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick
    except Exception as e:
        print(f"Error in picking dice1: {e}")

    # === Step 2: Pull open the drawer using the handle ===
    try:
        # Approach along x-axis (axis=0) for pulling the drawer handle
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull
    except Exception as e:
        print(f"Error in pulling drawer: {e}")

    # === Step 3: Place the die into the drawer ===
    try:
        # Place into the right side of the top drawer, approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)  # execute_place
    except Exception as e:
        print(f"Error in placing dice1 into drawer: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()