from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move from ready-pose to floor (where handle and dice are located)
    try:
        robot.execute_movement(Object["floor"], mode=7)
    except Exception as e:
        print(f"Error in Step 1 (move to floor): {e}")

    # Step 2: Pick drawer handle (approach along x-axis for handle)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 2 (pick drawer handle): {e}")

    # Step 3: Move from floor to drawer-area
    try:
        robot.execute_movement(Object["drawer-area"], mode=7)
    except Exception as e:
        print(f"Error in Step 3 (move to drawer-area): {e}")

    # Step 4: Pull drawer open using handle (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 4 (pull drawer open): {e}")

    # Step 5: Move from drawer-area to floor
    try:
        robot.execute_movement(Object["floor"], mode=7)
    except Exception as e:
        print(f"Error in Step 5 (move to floor): {e}")

    # Step 6: Pick dice1 (approach along z-axis for general object)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 6 (pick dice1): {e}")

    # Step 7: Move from floor to drawer-area
    try:
        robot.execute_movement(Object["drawer-area"], mode=7)
    except Exception as e:
        print(f"Error in Step 7 (move to drawer-area): {e}")

    # Step 8: Place dice1 into drawer (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 8 (place dice1 in drawer): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()