from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Move from ready-pose to floor to pick up dice1
        robot.execute_movement(Object["ready-pose"], Object["floor"], mode=7)
        # Pick dice1 from floor (axis=2 for object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Move from floor to floor to pick up handle_top (redundant, but per plan)
        robot.execute_movement(Object["floor"], Object["floor"], mode=7)
        # Pick handle_top from floor (axis=0 for handle)
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        # Move from floor to drawer-area to pull the drawer
        robot.execute_movement(Object["floor"], Object["drawer-area"], mode=7)
        # Pull the drawer open using handle at drawer-area (axis=0, distance=0.1)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Place dice1 into drawer_top at drawer-area (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()