from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Move from ready-pose to handle_top (simulate move to handle location)
        robot.execute_movement(mode=7)
        # Step 2: Pick handle_top at handle_top location (axis=0 for handle)
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        # Step 3: Pull drawer_top using handle_top (axis=0, distance=0.1)
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)
        # Step 4: Pick dice1 at dice1 location (axis=2 for object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 5: Move to ready-pose (simulate move)
        robot.execute_movement(mode=7)
        # Step 6: Place dice1 into drawer_top (axis=2 for object, use left place position)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 7: Move back to ready-pose (simulate move)
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()