from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for the task:
        1) Open the top drawer with the handle.
        2) Take the trash from inside the drawer and throw it into the bin.
        3) Pick a dice from the floor and store it inside the (still-open) drawer.
        4) Close the drawer and return to the ready pose.
    The sequence strictly relies on the predefined primitive-skills exposed
    through RobotController.execute_movement().
    """

    robot = RobotController()

    try:
        # ------------------------------------------------------------------
        # 1. OPEN THE DRAWER  (pick handle  ➜  pull drawer)
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_top_handle"], mode=1, axis=0
        )  # execute_pick (grasp handle)
        robot.execute_movement(
            Object["drawer_top_handle"], mode=4, distance=0.10
        )  # execute_pull (open drawer)

        # ------------------------------------------------------------------
        # 2. REMOVE TRASH FROM THE DRAWER AND PLACE IT IN THE BIN
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["trash"], mode=1, axis=2
        )  # execute_pick (pick trash out of drawer)
        robot.execute_movement(
            Object["trash_bin"], mode=2, axis=2
        )  # execute_place (drop trash into bin)

        # ------------------------------------------------------------------
        # 3. PICK A DICE FROM THE FLOOR AND PUT IT INSIDE THE OPEN DRAWER
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["dice1"], mode=1, axis=2
        )  # execute_pick (grab dice from floor)
        robot.execute_movement(
            Object["drawer_top_place_left"], mode=2, axis=2
        )  # execute_place (store dice inside drawer)

        # ------------------------------------------------------------------
        # 4. CLOSE THE DRAWER AND RETURN TO READY POSE
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_top_handle"], mode=3, distance=0.10
        )  # execute_push (close drawer)
        robot.execute_movement(mode=8)  # go_to_ready_pose

    except KeyError as err:
        print(f"[ERROR] Object name not found in Object list: {err}")
    except Exception as exc:
        print(f"[ERROR] Unexpected error during task execution: {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()
