from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence for:
      1) Removing the trash from the drawer and dropping it into the bin.
      2) Picking one die from the floor and storing it inside the opened drawer.

    The sequence strictly follows the provided specification steps and uses
    only the predefined robot skills through RobotController.execute_movement.
    """

    robot = RobotController()

    try:
        # ------------------------------------------------------------
        #  STEP-BY-STEP ORACLE PLAN  (matches the specification order)
        # ------------------------------------------------------------

        # 1. execute_pick  ─ handle_top
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # 2. execute_go_ready
        robot.execute_movement(mode=8)

        # 3. execute_pull ─ drawer_top via handle_top
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.10)

        # 4. execute_pick ─ trash1 from opened drawer
        robot.execute_movement(Object["trash"], mode=1, axis=2)

        # 5. execute_go_ready
        robot.execute_movement(mode=8)

        # 6. execute_place ─ trash1 into bin
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)

        # 7. execute_go_ready
        robot.execute_movement(mode=8)

        # 8. execute_pick ─ dice1 from floor
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # 9. execute_go_ready
        robot.execute_movement(mode=8)

        # 10. execute_place ─ dice1 into drawer (any open spot)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # (Optional) Return to ready pose after completion
        robot.execute_movement(mode=8)

    except KeyError as missing:
        print(f"[ERROR] Missing object in Object list: {missing}")
    except Exception as exc:
        print(f"[ERROR] Exception during execution: {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()