from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for the task:
        1.  execute_go    : ready-pose  -> floor
        2.  execute_pick  : handle_top
        3.  execute_go    : floor       -> drawer-area
        4.  execute_pull  : drawer_top  (via handle_top)
        5.  execute_pick  : trash1
        6.  execute_place : trash1      -> bin
        7.  execute_go    : drawer-area -> floor
        8.  execute_pick  : dice1
        9.  execute_go    : floor       -> drawer-area
       10.  execute_place : dice1       -> drawer_top
       11.  execute_push  : drawer_top  (close)
       12.  execute_go    : drawer-area -> ready-pose
    """

    robot = RobotController()

    # --- Helper poses for locations that may not be stored in Object list ---
    dummy_pose = (0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    pose_ready   = Object.get("ready-pose",   dummy_pose)
    pose_floor   = Object.get("floor",        dummy_pose)
    pose_drawer  = Object.get("drawer-area",  dummy_pose)

    try:
        # 1. go: ready-pose -> floor
        robot.execute_movement(pose_floor, mode=7)

        # 2. pick: handle_top (drawer handle, approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # 3. go: floor -> drawer-area
        robot.execute_movement(pose_drawer, mode=7)

        # 4. pull: open drawer with handle_top (along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)

        # 5. pick: trash1 (normal object, approach along z-axis)
        robot.execute_movement(Object["trash"], mode=1, axis=2)

        # 6. place: trash1 into bin (z-axis placement)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)

        # 7. go: drawer-area -> floor
        robot.execute_movement(pose_floor, mode=7)

        # 8. pick: dice1
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # 9. go: floor -> drawer-area
        robot.execute_movement(pose_drawer, mode=7)

        # 10. place: dice1 inside drawer (left position target)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # 11. push: close drawer (push along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.10)

        # 12. go: drawer-area -> ready-pose
        robot.execute_movement(pose_ready, mode=7)

    except KeyError as key_error:
        print(f"[Task Error] Undefined object key: {key_error}")
    except Exception as exc:
        print(f"[Task Error] {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()
