from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence that satisfies the task:
        1) Pull the top drawer open with its handle
        2) Take the trash out of the drawer and drop it in the bin
        3) Pick one die from the floor and put it in the (still-open) drawer
        4) Push the drawer closed
        5) Return to the ready pose
    All steps are executed only with the predefined primitive skills.
    """

    robot = RobotController()

    # ------------------------------------------------------------------
    # 1. Move to the top-drawer handle, grasp it and pull the drawer open
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=7)                      # execute_go  (ready-pose -> handle)
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)              # execute_pick (grab handle – approach in x)
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull (open drawer)

    # ---------------------------------------------------------
    # 2. Pick the trash from the now-open drawer and bin it
    # ---------------------------------------------------------
    robot.execute_movement(Object["trash"], mode=7)                                  # execute_go  (handle -> trash pose inside drawer)
    robot.execute_movement(Object["trash"], mode=1, axis=2)                          # execute_pick (pick trash – approach in z)
    robot.execute_movement(Object["trash_bin"], mode=7)                              # execute_go  (trash -> bin)
    robot.execute_movement(Object["trash_bin"], mode=2, axis=2)                      # execute_place (drop trash in bin)
    robot.execute_movement(mode=8)                                                   # go_to_ready_pose (optional reset of robot state)

    # ---------------------------------------------------------
    # 3. Pick one die from the floor and put it in the drawer
    # ---------------------------------------------------------
    robot.execute_movement(Object["dice1"], mode=7)                                  # execute_go  (ready -> dice on floor)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)                          # execute_pick (pick dice – approach in z)
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)                  # execute_go  (dice -> position inside open drawer)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)          # execute_place (place dice)

    # ----------------------------------------
    # 4. Push the drawer closed via its handle
    # ----------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=7)                      # execute_go  (drawer location -> handle)
    robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)  # execute_push (close drawer)

    # -----------------------------
    # 5. Return to the ready pose
    # -----------------------------
    robot.execute_movement(mode=8)                                                   # go_to_ready_pose


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()