from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for the task:
      1) Pull the top drawer open with the handle.
      2) Remove the trash from the drawer and put it in the bin.
      3) Pick one dice from the floor and place it inside the drawer.
      4) Close the drawer and return to the ready pose.
    The sequence follows the step-by-step specification exactly, using only the
    predefined skills exposed through `RobotController.execute_movement`.
    """

    robot = RobotController()

    # ------------------------------------------------------------------
    #  Step-by-Step Execution (matches the given specification order)
    # ------------------------------------------------------------------

    # 1. execute_go   : ready-pose  -> handle_top_pose
    robot.execute_movement(Object["drawer_top_handle"], mode=7)

    # 2. execute_pick : handle_top (lying on floor)
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

    # 3. execute_pull : pull drawer open with handle
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)

    # 4. execute_go   : handle_top_pose -> drawer_trash_pose
    robot.execute_movement(Object["trash"], mode=7)

    # 5. execute_pick : trash1 from inside the drawer
    robot.execute_movement(Object["trash"], mode=1, axis=2)

    # 6. execute_go   : drawer_trash_pose -> bin_pose
    robot.execute_movement(Object["trash_bin"], mode=7)

    # 7. execute_place: trash1 into bin
    robot.execute_movement(Object["trash_bin"], mode=2, axis=2)

    # 8. execute_go   : bin_pose -> dice1_pose
    robot.execute_movement(Object["dice1"], mode=7)

    # 9. execute_pick : dice1 from floor
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # 10. execute_go  : dice1_pose -> drawer_place_pose
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)

    # 11. execute_place: dice1 inside the drawer
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # 12. execute_push : close the drawer
    robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.10)

    # 13. execute_go   : drawer_place_pose -> ready-pose
    robot.execute_movement(mode=8)   # go_to_ready_pose


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()