from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Place one dice into a drawer.
    Follows the plan and specification strictly, using only provided skills.
    """
    robot = RobotController()

    # Step 1: Move from ready-pose to handle_top_location (drawer_top_handle)
    robot.execute_movement(Object["drawer_top_handle"], mode=7)

    # Step 2: Pick handle_top at handle_top_location (drawer_top_handle), approach along x-axis (axis=0)
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

    # Step 3: Move from handle_top_location to drawer_top_location (drawer_top_handle)
    robot.execute_movement(Object["drawer_top_handle"], mode=7)

    # Step 4: Pull drawer open using handle at drawer_top_location (drawer_top_handle), axis=0, distance=0.1
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

    # Step 5: Move from drawer_top_location to dice1_location (yellow_dice)
    robot.execute_movement(Object["yellow_dice"], mode=7)

    # Step 6: Pick dice1 at dice1_location (yellow_dice), approach along z-axis (axis=2)
    robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)

    # Step 7: Move from dice1_location to drawer_top_location (drawer_top_handle)
    robot.execute_movement(Object["drawer_top_handle"], mode=7)

    # Step 8: Place dice1 into drawer at drawer_top_location (drawer_top_handle), approach along z-axis (axis=2)
    robot.execute_movement(Object["drawer_top_handle"], mode=2, axis=2)

    # Step 9: Move back to ready-pose after placing the dice
    robot.execute_movement(Object["ready_pose"], mode=7)

def main():
    """Main entry point for the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()