from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one die (dice1) into the drawer (drawer_top) as per the domain and observation."""
    robot = RobotController()

    try:
        # Move to the location of handle_top (drawer-area)
        robot.execute_movement(Object["handle_top"], mode=7, from_location="ready-pose", to_location="drawer-area")

        # Pick handle_top from floor (approach along z-axis)
        robot.execute_movement(Object["handle_top"], mode=1, axis=2)

        # Pull drawer_top open using handle_top at drawer-area (approach along x-axis)
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)

        # Place handle_top aside (optional, if required by robot controller)
        robot.execute_movement(Object["handle_top"], mode=2, axis=2)

        # Move to the location of dice1 (floor)
        robot.execute_movement(Object["dice1"], mode=7, from_location="drawer-area", to_location="floor")

        # Pick dice1 from floor (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move to the open drawer (drawer-area)
        robot.execute_movement(Object["dice1"], mode=7, from_location="floor", to_location="drawer-area")

        # Place dice1 into drawer_top at drawer-area (approach along z-axis)
        robot.execute_movement(Object["drawer_top"], mode=2, axis=2)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for inserting one die into a drawer."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()