"""Module to drop one dice into any open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Drops one dice into any open drawer."""
    robot = RobotController()

    # Step 1: Move to the location of the dice (assume 'floor' is where dice1 is)
    robot.execute_movement(Object["dice1"], mode=7)

    # Step 2: Pick up dice1 from the floor (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 3: Move to the open drawer area (assume 'drawer_top_place_left' is above open drawer)
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)

    # Step 4: Place dice1 into the open drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

def main():
    """Main function to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()