"""Module to put a single dice into the drawer using RobotController."""

from Object_list import Object
from skill_mapping import RobotController

def put_dice_in_drawer():
    """Put a single dice into the drawer."""
    robot = RobotController()
    # Move to dice location
    robot.execute_movement(Object["dice1"], mode=7)
    # Pick the dice (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    # Move to drawer location
    robot.execute_movement(Object["drawer_top"], mode=7)
    # Place the dice into the drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_top"], mode=2, axis=2)

def main():
    """Main function to execute the task."""
    put_dice_in_drawer()

if __name__ == "__main__":
    main()