"""Module to store a dice inside the drawer using primitive robot actions."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence of actions to store dice1 inside drawer_top."""
    robot = RobotController()

    # Move from ready-pose to floor
    robot.execute_movement(Object["dice1"], mode=7)

    # Pick dice1 from floor (axis=2 for general object)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Pick handle_top from floor (axis=0 for handle)
    robot.execute_movement(Object["handle_top"], mode=1, axis=0)

    # Move from floor to drawer-area
    robot.execute_movement(Object["handle_top"], mode=7)

    # Pull drawer open using handle_top (axis=0 for handle)
    robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)

    # Place dice1 into drawer_top (axis=2 for general object)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # Push drawer closed (axis=2 for push, but axis param not used in push in this API)
    robot.execute_movement(Object["handle_top"], mode=3, axis=2, distance=0.1)

def main():
    """Main function to execute the dice storing task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()