"""Module to place one dice into a drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Place one dice into a drawer."""
    robot = RobotController()

    # Move to dice1 location
    robot.execute_movement(Object["dice1"], mode=7)

    # Pick the dice (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Move to drawer_top_place_left location
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)

    # Place the dice into the drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

def main():
    """Main function to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()