from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Executes the sequence to put a single dice into the drawer.
    """
    robot = RobotController()

    # Step 1: Move from ready-pose to handle_top location
    robot.execute_movement(Object["handle_top"], mode=7)  # execute_go

    # Step 2: Pick the handle (handle_top) from the floor (approach along x-axis)
    robot.execute_movement(Object["handle_top"], mode=1, axis=0)  # execute_pick

    # Step 3: Move from handle_top location to drawer_top handle location
    robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

    # Step 4: Pull the drawer open using the handle (approach along x-axis)
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

    # Step 5: Move from drawer_top handle location to dice1 location
    robot.execute_movement(Object["dice1"], mode=7)  # execute_go

    # Step 6: Pick the dice1 from the floor (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

    # Step 7: Move from dice1 location to drawer_top place location (use left place)
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)  # execute_go

    # Step 8: Place the dice1 into the drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

    # Step 9: Push the drawer closed (approach along x-axis)
    robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)  # execute_push

def main():
    """
    Main function to execute the long horizon task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()