"""Module to store a dice inside the drawer using robot skills."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store dice1 inside drawer_top."""
    robot = RobotController()

    # Step 1: Move to handle_top location
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
    except Exception as error:
        print(f"Error in Step 1 (go to handle_top_location): {error}")

    # Step 2: Pick handle_top at handle_top_location (axis=0 for handle)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as error:
        print(f"Error in Step 2 (pick handle_top): {error}")

    # Step 3: Pull drawer_top using handle_top at handle_top_location
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in Step 3 (pull drawer_top): {error}")

    # Step 4: Move to dice1 location
    try:
        robot.execute_movement(Object["dice1"], mode=7)
    except Exception as error:
        print(f"Error in Step 4 (go to dice1_location): {error}")

    # Step 5: Pick dice1 at dice1_location (axis=2 for general object)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as error:
        print(f"Error in Step 5 (pick dice1): {error}")

    # Step 6: Move to drawer_top (open) for placing inside
    try:
        robot.execute_movement(Object["drawer_top"], mode=7)
    except Exception as error:
        print(f"Error in Step 6 (go to drawer_top for placing inside): {error}")

    # Step 7: Place dice1 inside drawer_top (axis=2 for general object)
    try:
        robot.execute_movement(Object["drawer_top"], mode=3, axis=2)
    except Exception as error:
        print(f"Error in Step 7 (place dice1 inside drawer): {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()