from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Place one dice into a drawer ===
    # Execute the oracle plan as per Specification:

    # Step 1: Move to the dice location (assume dice1 as the target dice)
    try:
        robot.execute_movement(Object["dice1"], mode=7)  # execute_go
    except Exception as e:
        print(f"[Step 1] Failed to move to dice1 location: {e}")

    # Step 2: Pick up the dice (approach along z-axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick, axis=2 for z-axis
    except Exception as e:
        print(f"[Step 2] Failed to pick dice1: {e}")

    # Step 3: Move to the drawer handle location (assume top drawer for this example)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go
    except Exception as e:
        print(f"[Step 3] Failed to move to drawer handle: {e}")

    # Step 4: Pull/open the drawer using the handle (pull along x-axis, axis=0, distance=0.1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull
    except Exception as e:
        print(f"[Step 4] Failed to pull (open) drawer: {e}")

    # Step 5: Move to the drawer opening position (assume left side of top drawer)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)  # execute_go
    except Exception as e:
        print(f"[Step 5] Failed to move to drawer opening: {e}")

    # Step 6: Place the dice into the drawer (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place
    except Exception as e:
        print(f"[Step 6] Failed to place dice1 into drawer: {e}")

    # Optionally: Return to ready-pose for completeness
    try:
        robot.execute_movement(mode=8)  # go_to_ready_pose
    except Exception as e:
        print(f"[Finish] Failed to return to ready-pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()