from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan for 'Insert one die into a drawer.'
    Uses only the allowed skills and steps as per specification.
    Goal: Pick up a die (dice1) and insert it into the top drawer.
    """

    robot = RobotController()

    try:
        # Step 1: execute_pick the die (dice1), axis=2 (z/top-down)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 1 (execute_pick dice1): {e}")

    try:
        # Step 2: execute_pull to open the top drawer using the handle (approach from x-axis/side), axis=0
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 2 (execute_pull drawer handle): {e}")

    try:
        # Step 3: execute_place to put the die in the drawer (drawer_top_place_left), axis=2 (z/top-down)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 3 (execute_place die in drawer): {e}")

    try:
        # (Optional cleanup) Push to close the drawer after placing the die
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Extra Step (execute_push to close drawer): {e}")

    try:
        # (Optional cleanup) Return to ready pose for next episode/task
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in Final Step (go_to_ready_pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
