from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for: Store a dice inside the drawer.
    Executes the plan step by step using only the provided skills.
    """

    robot = RobotController()
    try:
        # Step 1: Move to drawer handle location (execute_go)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Pick up the drawer handle (approach x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Pull the drawer open using handle, approach x-axis, distance=0.1
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Pick up dice1 from its location, approach z-axis
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Place dice1 inside the drawer, approach z-axis
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Push drawer closed, approach x-axis, distance=0.1
        robot.execute_movement(Object["drawer_top_place_left"], mode=3, axis=0, distance=0.1)

        # Return to ready pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()