from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # === Step 1: Move from ready-pose to drawer-area ===
    # Action: execute_go (mode=7)
    try:
        # If 'drawer_area' pose not defined, just pass None.
        robot.execute_movement(Object.get("drawer_area", None), mode=7)
    except Exception as e:
        print("Error in Step 1 (execute_go to drawer-area):", e)
    
    # === Step 2: Pick the handle ("drawer_top_handle") at drawer-area ===
    # Action: execute_pick (mode=1), axis=0 (x-axis for handle)
    try:
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=1, axis=0)
    except Exception as e:
        print("Error in Step 2 (execute_pick on drawer_top_handle):", e)
    
    # === Step 3: Pull to open the drawer ("drawer_top") with handle ===
    # Action: execute_pull (mode=4), axis=0, distance=0.1
    try:
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=4, axis=0, distance=0.1)
    except Exception as e:
        print("Error in Step 3 (execute_pull on drawer_top_handle):", e)
    
    # === Step 4: Pick up "dice1" at drawer-area ===
    # Action: execute_pick (mode=1), axis=2 (z-axis for dice)
    try:
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as e:
        print("Error in Step 4 (execute_pick on dice1):", e)
    
    # === Step 5: Place "dice1" into the open drawer ("drawer_top") ===
    # Place at "drawer_top_place_left", axis=2 (z-axis)
    try:
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)
    except Exception as e:
        print("Error in Step 5 (execute_place dice1 into drawer_top):", e)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()