from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle plan to place one dice into a drawer,
    strictly following the required skills and the provided plan specification.
    """
    robot = RobotController()

    # Step 1: Move to dice1 location (execute_go)
    try:
        robot.execute_movement(Object["dice1"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 1 (execute_go to dice1): {e}")

    # Step 2: Pick up dice1 (execute_pick, approach z axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"[ERROR] Step 2 (execute_pick dice1): {e}")

    # Step 3: Move to drawer_top_handle location (execute_go)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 3 (execute_go to drawer_top_handle): {e}")

    # Step 4: Pick up drawer_top_handle (execute_pick, approach x axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Step 4 (execute_pick drawer_top_handle): {e}")

    # Step 5: Pull to open the drawer (execute_pull at handle, along x, distance=0.1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"[ERROR] Step 5 (execute_pull drawer handle): {e}")

    # Step 6: Move to drawer_top_place_left location (execute_go)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
    except Exception as e:
        print(f"[ERROR] Step 6 (execute_go to drawer_top_place_left): {e}")

    # Step 7: Place dice1 into drawer (execute_place, approach z axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"[ERROR] Step 7 (execute_place dice1 in drawer): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()