from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up the die (assume dice1) from the floor - approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        
        # Step 2: Pull to open the drawer using the handle
        # Approach handle directly (axis=0), use pull (mode=4), set a reasonable pull distance
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        
        # Step 3: Place the die into the drawer (use drawer top left place as insertion pose)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        
        # Optionally, return to ready pose after task
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"[ERROR] Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()