from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    '''
    Oracle sequence for: Store a dice inside the drawer.
    Steps according to the given specification:
      1. Pick dice at dice_location (mode=1, axis=2)
      2. Go to handle_location (mode=7)
      3. Pull drawer using handle at handle_location (mode=4, axis=0, distance=0.1)
      4. Go to drawer_opening_location (mode=7)
      5. Place dice in drawer_place_location (mode=2, axis=2)
      6. Push drawer closed from drawer_front_location (mode=3, axis=0, distance=0.1)
    '''

    robot = RobotController()

    # [Frozen Code Start]
    robot.execute_movement(Object["ready-pose"], Object["floor"], mode=7)
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    robot.execute_movement(Object["floor"], Object["drawer-area"], mode=7)
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0)
    robot.execute_movement(Object["drawer-area"], Object["floor"], mode=7)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    robot.execute_movement(Object["floor"], Object["drawer-area"], mode=7)
    # [Frozen Code End]

    try:
        # Step 5: Place dice1 into drawer (drawer_top_place_left is used)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 5 (place dice): {e}")

    try:
        # Step 6: Push drawer closed at drawer front location (use drawer_top_handle as a reference for the front)
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 6 (push drawer): {e}")

    try:
        # Final: Go to ready-pose from drawer-area
        robot.execute_movement(Object["drawer-area"], Object["ready-pose"], mode=7)
    except Exception as e:
        print(f"Error in Final Step (go to ready-pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()