from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to achieve the goal: Place one dice (handle3) into the open drawer (drawer1).
    Follows the given specification steps:
      1. execute_pick handle3 at ready-pose
      2. execute_place handle3 into drawer1 at ready-pose
    Uses only the provided skills and object list.
    """
    robot = RobotController()
    try:
        # 1. Pick up handle3 from the floor (mapped to "drawer_bottom_handle" in Object list)
        #    - The skeleton and object_names mapping:
        #      handle3 ≈ "drawer_bottom_handle"
        #      ready-pose is the starting location; axis=2 for picking up from above.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=2)
        
        # 2. Place handle3 into the open drawer1 (mapped to "drawer_top_place_left" or "drawer_top_place_right")
        #    - We assume placing to "drawer_top_place_left" as a representative pose for placing in drawer1.
        #    - axis=2 for placing from above.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during oracle task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
