from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: execute_pick(handle1, ready-pose)
        # handle1 maps to "drawer_top_handle" in Object_list
        # Approach along x-axis (axis=0) for handles
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: execute_place(handle1, drawer1, ready-pose)
        # Place the handle into the open drawer (drawer1), at "drawer_top_place_left" or "drawer_top_place_right"
        # Since the precise drawer place is not specified in the plan, we use "drawer_top_place_left"
        # Place actions for objects into drawers generally use z-axis approach (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()