from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up handle1 (which corresponds to drawer_top_handle as per object_names and mapping)
        # Use axis=0 for handles (side grasp)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Place handle1 into drawer1 (topmost drawer, assumed at "drawer_top_place_left" or "drawer_top_place_right")
        # The initial state and the PDDL problem says drawer1 is open and empty.
        # We'll use drawer_top_place_left as the default place for the object into the open drawer.
        # Use axis=2 for a top-down "place"
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()