from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for: Place one dice into the open drawer.

    The plan, from the specification, is:
      1. execute_pick(handle1, ready-pose)
      2. execute_place(handle1, drawer1, ready-pose)

    This is mapped to:
      - handle1 is 'drawer_top_handle' in Object_list.
      - drawer1 is the open drawer at task start (drawer1 is open, per observation).
      - ready-pose is the robot's starting location; here, Object list does not include "ready-pose" but this is the default robot configuration.

    Since "drawer_top_handle" is on the floor, and the goal is to put a dice (handle1) into the open drawer (drawer1), 
    we'll use the pre-defined object names accordingly.

    The axis for picking the handle should be 0 (x-axis) for handles (see instructions).
    The axis for placing in the drawer can be 0 or 2; here, let's use axis=0.
    """

    robot = RobotController()

    try:
        # Step 1: Pick 'handle1' (drawer_top_handle) from ready-pose.
        # axis=0 since we are picking a handle.
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick: {e}")

    try:
        # Step 2: Place 'handle1' (drawer_top_handle) into 'drawer1' (the open drawer).
        # Place location: per usual convention, use the left place location.
        # axis=0 for approaching drawer.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=0)
    except Exception as e:
        print(f"Error during execute_place: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()