from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Task: Put a single dice (handle1: treated as the dice object) in the already open drawer (drawer1).
    Plan (from specification):
      1. execute_pick(handle1, ready-pose)
      2. execute_place(handle1, drawer1, ready-pose)
    Only predefined skills must be used, as mapped in RobotController.
    """

    robot = RobotController()

    try:
        # Step 1: Pick up handle1 from the ready-pose location
        # According to domain: when grasping handles, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        
        # Step 2: Place handle1 into drawer1 (already open, ready-pose location), approach along x-axis
        robot.execute_movement(Object["drawer_top_handle"], mode=2, axis=0)
    except Exception as e:
        print(f"Error occurred during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()