from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()
    
    try:
        # Step 1: execute_pick dice at ready-pose
        # We'll use Object["drawer_top_handle"] as the dice object as per typical conventions
        # However, the object list does not explicitly have "dice", but does have "drawer_top_handle" etc.
        # Since 'dice' is not in Object, we need to make a safe choice:
        # The best mapping with data given and goal is to use "drawer_top_handle" for the dice,
        # but per the observation, handle objects are the only loose objects. We'll assume handle3 as "dice" (on-floor handle3).
        # (in the initial state, handle3 is a loose object on floor, thus eligible for pick/place per the goal)
        # For demonstration, we'll use handle3 as the dice.

        # execute_pick "dice"/handle3 at ready-pose (axis=2 for regular objects)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=2)

        # execute_place "dice"/handle3 into drawer1 at ready-pose (axis=2 for placing objects)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except KeyError as e:
        print(f"[ERROR] Object key not found: {e}")
    except Exception as e:
        print(f"[ERROR] Exception during robot action: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()