from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence to move one dice (handle1) to the drawer that's already open (drawer1) using
    only the allowed skills per specification. 
    """
    robot = RobotController()

    try:
        # === Step 1: Pick up handle1 (the "dice") from the floor at ready-pose ===
        # Object mapping: "handle1" is represented as "drawer_top_handle" in Object_list.
        # Specification says to use execute_pick with axis=0 for handles.
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # === Step 2: Place handle1 (the "dice") into the open drawer ===
        # "drawer1" is represented as the top drawer; placing at ready-pose location.
        # 'execute_place' typically requires axis=2 for top-down place.
        robot.execute_movement(Object["drawer_top_handle"], mode=2, axis=2)

    except Exception as e:
        print(f"Exception encountered during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
