from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to place one dice (dice1) into the open drawer (drawer1).
    The robot starts at ready-pose and uses only the required skills as per specification.
    """
    robot = RobotController()
    
    try:
        # Step 1: Pick up dice1 from ready-pose (on the floor)
        # axis=2: approach from z-axis for general objects
        robot.execute_movement(Object["item1"], mode=1, axis=2)

        # Step 2: Place dice1 into drawer1 at ready-pose
        # axis=2: for placing into drawer
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    
    except Exception as e:
        print(f"Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
